// SPDX-FileCopyrightText: Copyright 2022 yuzu Emulator Project
// SPDX-License-Identifier: MPL-2.0

#pragma once

#include <array>
#include <span>
#include <string>

#include <audio_core/renderer/command/icommand.h>
#include <audio_core/common/common_types.h>

namespace AudioCore::AudioRenderer {
namespace ADSP {
class CommandListProcessor;
}

/**
 * AudioRenderer command for sinking samples to an output device.
 */
struct DeviceSinkCommand : ICommand {
    /**
     * Print this command's information to a string.
     *
     * @param processor - The CommandListProcessor processing this command.
     * @param string - The string to print into.
     */
    void Dump(const ADSP::CommandListProcessor& processor, std::string& string) override;

    /**
     * Process this command.
     *
     * @param processor - The CommandListProcessor processing this command.
     */
    void Process(const ADSP::CommandListProcessor& processor) override;

    /**
     * Verify this command's data is valid.
     *
     * @param processor - The CommandListProcessor processing this command.
     * @return True if the command is valid, otherwise false.
     */
    bool Verify(const ADSP::CommandListProcessor& processor) override;

    /// Device name
    char name[0x100];
    /// System session id (unused)
    s32 session_id;
    /// Sample buffer to sink
    std::span<s32> sample_buffer;
    /// Number of input channels
    u32 input_count;
    /// Mix buffer indexes for each channel
    std::array<s16, MaxChannels> inputs;
};

} // namespace AudioCore::AudioRenderer
