// SPDX-License-Identifier: MPL-2.0
// Copyright © 2021 Skyline Team and Contributors (https://github.com/skyline-emu/)

#pragma once

#include <array>
#include <cstdint>
#include <algorithm>
#include "log.h"

using u128 = __uint128_t; //!< Unsigned 128-bit integer
using u64 = __uint64_t; //!< Unsigned 64-bit integer
using u32 = __uint32_t; //!< Unsigned 32-bit integer
using u16 = __uint16_t; //!< Unsigned 16-bit integer
using u8 = __uint8_t; //!< Unsigned 8-bit integer

using s128 = __int128_t; //!< Signed 128-bit integer
using s64 = __int64_t; //!< Signed 64-bit integer
using s32 = __int32_t; //!< Signed 32-bit integer
using s16 = __int16_t; //!< Signed 16-bit integer
using s8 = __int8_t; //!< Signed 8-bit integer

using f32 = float; //!< 32-bit floating point
using f64 = double; //!< 64-bit floating point

using u16_le = u16;
using u32_le = u32;
using s32_le = s32;

using VAddr = u64;    ///< Represents a pointer in the userspace virtual address space.
