// SPDX-FileCopyrightText: Copyright 2022 yuzu Emulator Project
// SPDX-License-Identifier: MPL-2.0

#pragma once

#include <string>

#include <audio_core/renderer/command/icommand.h>
#include <audio_core/common/common_types.h>

namespace AudioCore::AudioRenderer {
namespace ADSP {
class CommandListProcessor;
}

/**
 * AudioRenderer command for applying volume to a mix buffer, with ramping for the volume to smooth
 * out the transition.
 */
struct VolumeRampCommand : ICommand {
    /**
     * Print this command's information to a string.
     *
     * @param processor - The CommandListProcessor processing this command.
     * @param string    - The string to print into.
     */
    void Dump(const ADSP::CommandListProcessor& processor, std::string& string) override;

    /**
     * Process this command.
     *
     * @param processor - The CommandListProcessor processing this command.
     */
    void Process(const ADSP::CommandListProcessor& processor) override;

    /**
     * Verify this command's data is valid.
     *
     * @param processor - The CommandListProcessor processing this command.
     * @return True if the command is valid, otherwise false.
     */
    bool Verify(const ADSP::CommandListProcessor& processor) override;

    /// Fixed point precision
    u8 precision;
    /// Input mix buffer index
    s16 input_index;
    /// Output mix buffer index
    s16 output_index;
    /// Previous mix volume applied to the input
    f32 prev_volume;
    /// Current mix volume applied to the input
    f32 volume;
};

} // namespace AudioCore::AudioRenderer
